' "DHT Test Emulator 06.bas"
'  One pin version. Link DHTpin and Gnd. to other Pico.
'  If wires are short no pullup resistor is needed.
Const DHTpin = MM.Info(pinno GP0)
SetPin DHTpin, DIn, pullup

Dim integer a(83), b1, b2, b3, b4, b5, word, n, m, q=0 'start value for byte incrementer
Dim float t, z= 1.5  '"wake" pulse duration - 1.5 = DHT22, 19.5 = DHT11

'measure first "wake" pulse to set start delay time.
' HUMID won't get a resopnse for 1st reading.
Print "Waiting to measure first pulse"
Do While Pin(DHTpin):Loop :t=Timer
Do :Loop Until Pin(DHTpin):z=Timer-t
Print "Wake Pulse measurement:-";z;"mS" :Print

Do
  Math Set 50, a() : a(0)=80 : a(1)=80

'  Input "type the 4 bytes "; b1, b2, b3, b4 'enter byte values at console

'  If b1 = 0 Then ' set default values if zero Input
    b1=66 : b2=110 : b3=44 : b4=q 'choose the initial byte values
'  EndIf

  b5 = (b1+b2+b3+b4) And 255 'make checksum
'  Print "Sending "; b1, b2, b3, b4, b5

  word = ((b1 And 255)<<32)+((b2 And 255)<<24)+((b3 And 255)<<16)+((b4 And 255)<<8)+b5
  m=0 : Print Bin$(word,40)
  For n=81 To 2 Step -2
    a(n) = 27 + 43 * ((word >> m) And 1)
'    Print n,m,a(n)
    Inc m
  Next

  Print "Waiting to receive HUMID command (either type 0 or 1)"

  Do While Pin(DHTpin) : Loop
  t=Timer + z '0.9 = DHT22, 19 = DHT11
  SetPin DHTpin, off :Pin(DHTpin) = 1:SetPin DHTpin, DOut
  Do : Loop Until Timer>t

  Device BitStream DHTpin, 83, a() ': endif

  SetPin DHTpin, off : SetPin DHTpin, din, pullup

  Inc q :q=q And 255
  Print "Sent "; b1, b2, b3, b4, "CSum"; b5, "Byte Sum ="; b1+b2+b3+b4,,"Wake Pulse";z;"mS"
Loop
End
'other Pico
'do: humid gp0,t,h,1:? t,h,,:humid gp1,t1,h1,1:if t=1000 then:inc e :endif:? t1,h1,,time$,,e :pause 9999:loop
          